/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.item.ItemCoFH;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.lib.api.ContainerType;
import cofh.lib.api.item.IColorableItem;
import cofh.lib.api.item.IFluidContainerItem;
import cofh.lib.fluid.FluidContainerItemWrapper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;

public class FluidContainerItem
extends ItemCoFH
implements IFluidContainerItem,
IColorableItem {
    protected Predicate<FluidStack> validator;
    protected int fluidCapacity;

    public FluidContainerItem(Item.Properties builder, int fluidCapacity, Predicate<FluidStack> validator) {
        super(builder);
        this.fluidCapacity = fluidCapacity;
        this.validator = validator;
        this.setEnchantability(5);
    }

    public FluidContainerItem(Item.Properties builder, int fluidCapacity) {
        this(builder, fluidCapacity, e -> true);
    }

    public FluidContainerItem setFluidCapacity(int fluidCapacity) {
        this.fluidCapacity = fluidCapacity;
        return this;
    }

    @Override
    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        FluidStack fluid = this.getFluid(stack);
        if (!fluid.isEmpty()) {
            tooltip.add((Component)StringHelper.getFluidName(fluid));
        }
        boolean creative = this.isCreative(stack, ContainerType.FLUID);
        tooltip.add((Component)StringHelper.getTextComponent(StringHelper.localize("info.cofh.amount") + ": " + (String)(creative ? StringHelper.localize("info.cofh.infinite") : StringHelper.format(fluid.getAmount()) + " / " + StringHelper.format(this.getCapacity(stack)) + " mB")));
        if (FluidHelper.hasPotionTag(fluid)) {
            tooltip.add((Component)StringHelper.getEmptyLine());
            tooltip.add((Component)StringHelper.getTextComponent(StringHelper.localize("info.cofh.effects") + ":"));
            FluidHelper.addPotionTooltip(fluid, tooltip);
        }
    }

    protected void potionTooltip(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn, List<MobEffectInstance> effects) {
        this.potionTooltip(stack, worldIn, tooltip, flagIn, effects, 1.0f);
    }

    protected void potionTooltip(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn, List<MobEffectInstance> effects, float durationFactor) {
        FluidStack fluid = this.getFluid(stack);
        if (!fluid.isEmpty()) {
            tooltip.add((Component)StringHelper.getFluidName(fluid));
        }
        tooltip.add((Component)(this.isCreative(stack, ContainerType.FLUID) ? StringHelper.getTextComponent("info.cofh.infinite_source") : StringHelper.getTextComponent(StringHelper.localize("info.cofh.amount") + ": " + StringHelper.format(fluid.getAmount()) + " / " + StringHelper.format(this.getCapacity(stack)) + " mB")));
        if (FluidHelper.hasPotionTag(fluid)) {
            tooltip.add((Component)StringHelper.getEmptyLine());
            tooltip.add((Component)StringHelper.getTextComponent(StringHelper.localize("info.cofh.effects") + ":"));
            FluidHelper.addPotionTooltip(effects, tooltip, durationFactor);
        }
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return newStack.m_41720_() != oldStack.m_41720_() || !ItemHelper.areItemStacksEqualIgnoreTags(oldStack, newStack, "Fluid");
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags(oldStack, newStack, "Fluid"));
    }

    public boolean m_142522_(ItemStack stack) {
        return !this.isCreative(stack, ContainerType.FLUID) && this.getFluidAmount(stack) > 0;
    }

    public int m_142158_(ItemStack stack) {
        return (int)Math.round(13.0 * (double)this.getFluidAmount(stack) / (double)this.getCapacity(stack));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidContainerItemWrapper(stack, this);
    }

    @Override
    public boolean isFluidValid(ItemStack container, FluidStack resource) {
        return this.validator.test(resource);
    }

    @Override
    public int getCapacity(ItemStack container) {
        return this.getMaxStored(container, this.fluidCapacity);
    }

    @Override
    public int getColor(ItemStack item, int colorIndex) {
        if (colorIndex == 1) {
            return this.getFluidAmount(item) > 0 ? FluidHelper.color(this.getFluid(item)) : 0xFFFFFF;
        }
        return 0xFFFFFF;
    }
}

